;0123456789012345678901234567890123456789012345678901234567890123456789012
;TITOLO: Termometro
;ENUNCIATO: Un sistema deve rilevare la temperatura di un liquido. Se esso
;supera i 100 gradi si deve attivare un dispositivo di raffreddamento. Nel
;momento in cui la temperatura rientra neilimiti consentiti, il
;raffreddamento si deve disattivare. Il programma deve continuare
;ciclicamente finche non viene premuto il pulsante di fine.
;OBIETTIVI: A	Codifica del programma attraverso diagramma di flusso.
;	    B	Uso delle istruzioni di assegnazione,
;               salti condizionati incondizionati.
;FINALITA': Gestire l'aquisizione di un dato a 8 bit e il blocco di
;           selezione.
;TABELLA ASSEGNAZIONE VARIABILI: P1.0/P1.7 = sensore di temperatura
;                                (se > 100 = T>100; se <= 100 = T<=100)
;                                P3.0 = sistema di raffreddamento
;                                (se 0 = attivo; se 1 = non attivo)


	 $MOD51		
                                ;Informa il cross-assembler circa il set
                                ;d'istruzioni da utilizzare

	 ORG 1000H
				;Stabilisce quale deve essere la cella di
                                ;memoria da cui cominciare la scrittura
                                ;del programma
	 SETB P3.0		;setta P3.0 a 1 e spegne il led
RIPETI:	 MOV A,P1		;sposta in A il contenuto di P1
	 CJNE A,#100,RAFFRED	;confronta A con il valore 100 e salta
				;all'etichetta se non sono =, altrimenti
				;procede
	 JMP ON			;salta all'etichetta ON
RAFFRED: JC OFF                 ;salta a OFF se C=1
ON:	 CLR P3.0		;resetta P3.0
	 JMP OLTRE		;salta a OLTRE
OFF:	 SETB P3.0		
OLTRE:	 MOV A,P1		
         CJNE A,#0,FINE         ;confronta il contenuto di A con il valore
				;0, se sono uguali va avanti e finisce, se
				;nn sono uguali salta a RIPETI continuando
				;l'esecuzione del programma.Lo 0 si
				;ottiene con la pressione di tutti i
				;pulsanti
	JMP RIPETI 
FINE:	NOP
	END
